if (!self.helpers) {
    self.helpers={};
}

//Set browser for Firefox extensions to be chrome
if (typeof browser!=='undefined') {
    window.chrome=browser;
}

self.helpers.tools=(function () {
    var _badgeIsLoadingTimeout, _showLoadingInterval;

    const postFetch=function (url, data, headers) {
        const options={
            method: 'POST',
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json;charset=UTF-8',
            },
            body: JSON.stringify(data),
        };

        if (headers) {
            options.headers=headers;
        }

        return fetch(url, options)
            .then(function (response) {
                if (!response.ok) {
                    return response.json().then((data)=>{
                        var error={
                            response: {
                                data: data,
                            },
                        };

                        return Promise.reject(error);
                    });
                }

                return response;
            })
            .then((response)=>response.json());
    };

    const messageRegex=/__MSG_(\w+)__/g;

    var localizeHtmlPage=function (elm) {
        for (var i=0; i<elm.children.length; i++) {
            localizeHtmlPage(elm.children[i]);
            if (elm.children[i].hasAttributes()) {
                for (var j=0; j<elm.children[i].attributes.length; j++) {
                    elm.children[i].attributes[j].name=elm.children[i].attributes[j].name.replace(messageRegex, localizeString);
                    elm.children[i].attributes[j].value=elm.children[i].attributes[j].value.replace(messageRegex, localizeString);
                }
            }
            if (elm.children[i].innerHTML.length) {
                elm.children[i].innerHTML=elm.children[i].innerHTML.replace(messageRegex, localizeString);
            }
        }
    };

    function localizeString(_, str) {
        return str ? chrome.i18n.getMessage(str) : '';
    }

    var showBadgeLoading=function () {
        // clearInterval(_showLoadingInterval);
        // clearTimeout(_badgeIsLoadingTimeout);
        // var context = document.createElement('canvas').getContext('2d');
        // var start = new Date();
        // var lines = 16,
        // 	cW = 40,
        // 	cH = 40;
        // _showLoadingInterval = setInterval(function () {
        // 	var rotation = parseInt(((new Date() - start) / 1000) * lines) / lines;
        // 	context.save();
        // 	context.clearRect(0, 0, cW, cH);
        // 	context.translate(cW / 2, cH / 2);
        // 	context.rotate(Math.PI * 2 * rotation);
        // 	for (var i = 0; i < lines; i++) {
        // 		context.beginPath();
        // 		context.rotate((Math.PI * 2) / lines);
        // 		context.moveTo(cW / 10, 0);
        // 		context.lineTo(cW / 4, 0);
        // 		context.lineWidth = cW / 30;
        // 		context.strokeStyle = 'rgba(67,170,232,' + i / lines + ')';
        // 		context.stroke();
        // 	}
        // 	var imageData = context.getImageData(10, 10, 19, 19);
        // 	chrome.action.setIcon({
        // 		imageData: imageData,
        // 	});
        // 	context.restore();
        // }, 1000 / 30);
        // _badgeIsLoadingTimeout = setTimeout(function () {
        // 	helpers.tools.hideBadgeLoading();
        // }, 5000);
    };

    var hideBadgeLoading=function () {
        // clearInterval(_showLoadingInterval);
        // chrome.action.setIcon({
        // 	path: 'media/icons/icon38.png',
        // });
    };

    var showLoading=function () {
        $('.loading').show();
    };

    var hideLoading=function () {
        $('.loading').hide();
    };

    var copyToClipboard=function (text) {
        if (navigator&&navigator.clipboard&&navigator.clipboard.writeText) {
            // navigator.clipboard.writeText(text);
            //Switched to document.execCommand because of issue with focus
            const textArea=document.createElement('textarea');
            textArea.value=text;
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            document.execCommand('copy');
            document.body.removeChild(textArea);
        } else {
            copyToClipboardServiceWorker(text);
        }
    };

    var copyToClipboardServiceWorker=function (text) {
        chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
            var activeTabId=tabs[0].id;

            chrome.scripting.executeScript({
                target: {tabId: activeTabId},
                args: [text],
                function: function (text) {
                    navigator.clipboard.writeText(text);
                    setTimeout(function () {
                        let element=document.createElement('div');
                        element.style.cssText=`
							font-family: "Helvetica Neue",Arial,sans-serif;
							min-width: 250px;
							margin-left: -125px;
							background-color: #64b26f;
							color: #fff;
							text-align: center;
							border-radius: 2px;
							padding: 16px;
							position: fixed;
							z-index: 9999;
							left: 50%;
							top: 30px;
							font-size: 17px;
							box-shadow: 0 3px 5px -1px rgb(0 0 0 / 20%), 0 6px 10px 0 rgb(0 0 0 / 14%), 0 1px 18px 0 rgb(0 0 0 / 12%);
						`;

                        element.innerHTML='Short URL copied to clipboard '+text;

                        document.body.append(element);

                        setTimeout(function () {
                            element.remove();
                        }, 4000);
                    });
                },
            });
        });
    };

    var openLink=function (urlToOpen) {
        chrome.tabs.create({
            url: urlToOpen,
        });
    };

    return {
        showBadgeLoading: showBadgeLoading,
        hideBadgeLoading: hideBadgeLoading,
        showLoading: showLoading,
        hideLoading: hideLoading,
        copyToClipboard: copyToClipboard,
        openLink: openLink,
        postFetch: postFetch,
        localizeHtmlPage: localizeHtmlPage,
        localizeString: localizeString,

    };
})();

self.helpers.short=(function () {
    var getShortLink=async function (longLink) {

         //
        var gooApi=await helpers.storage.getValue('goobyapi');
        if (!gooApi) {
            await handleError({message: 'Please signup first.Push Start here'});
            return false;
        }

        const pattern=new RegExp(
            '^(https?:\\/\\/)?'+ // protocol
            '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // domain name
            '((\\d{1,3}\\.){3}\\d{1,3}))'+ // OR IP (v4) address
            '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // port and path
            '(\\?[;&a-z\\d%_.~+=-]*)?'+ // query string
            '(\\#[-a-z\\d_]*)?$', // fragment locator
            'i'
        );

        if(!pattern.test(longLink)){
            await handleError({message: 'Please enter valid URL!'});
            return false;
        }

        if(longLink.includes('goo.by')){
            await handleError({message: 'Can`t short goo.by links!'});
            return false;
        }

        return serverShort(longLink, gooApi);

    };


    var serverShort=async function (longLink, apiKey) {
        let domain=await helpers.storage.getValue('ShortCurrentDomain')
        const data={
            url: longLink,
            domain: domain || 'https://goo.by',
        };

        const url='https://goo.by/api/url/add';

        const headers={
            'Accept': 'application/json',
            'Authorization': 'Token '+apiKey,
            'Content-Type': 'application/json;charset=UTF-8',
        }

        return helpers.tools
            .postFetch(url, data, headers)
            .then((response)=>{
                return handleSuccess(response, longLink);

            })
            .catch((error)=>{
                if (error&&error.response&&error.response.data) {

                    handleError(error.response.data);
                }
            });
    };

    var handleSuccess=async function (response, longLink) {
        var shortUrl=response.shorturl,
            includeHttps=await helpers.storage.getValue('includeHttps'),
            copyToClipboardSetting=(await helpers.storage.getValue('copyToClipboard'))??true;

        // shortUrl = shortUrl.replace(/(^\w+:|^)\/\//, '');

        // if (includeHttps) {
        // 	shortUrl = 'https://' + shortUrl;
        // }

        if (typeof jQuery!='undefined') {
            $('#shortenedLink').val(shortUrl);
            $('#short-domain').text(response.domain+'/');
            $('#short-id').val(response.short_id);
            $('#long-url').val(longLink);

            // $('#defaultShortenerFailed').toggle(!response.provider_success);

            $('#stats').attr('href', shortUrl+'+');

            var qrImageUrl=shortUrl+'/qr';
            var qrLink=shortUrl;

            $('#qr-code').attr('src', qrImageUrl);
            $('#qr-link').attr('href', qrLink);
            var currentLink=$('#shortenedLink').val();

            if (copyToClipboardSetting) {
                $('#shortenedLink').val('Copied!');
                helpers.tools.copyToClipboard(shortUrl);
            }

            setTimeout(function () {
                $('#shortenedLink').val(currentLink);
            }, 700);

            var playNotificationSound=await helpers.storage.getValue('notificationSound');
            if (playNotificationSound) {
                $('#successAudio')[0].play();
            }
            $('#copy-button').show();
            $('#link-info').show();
            $('#short-button').hide();

            helpers.tools.hideLoading();
            if (response.info) {
                if (response.info.description) {
                    $('#url-description').val(response.info.description);
                }

                if (response.info.title) {
                    $('#url-title').val(response.info.title);
                }

                if (response.info.twitter_url) {
                    $('#twitter-share').removeClass('hidden').attr('href', response.info.twitter_url);
                }

                if (response.info.facebook_url) {
                    $('#facebook-share').removeClass('hidden').attr('href', response.info.facebook_url);
                }

                if (response.info.can_update) {
                    $('#update-link-form').removeClass('hidden');
                }

                if (response.info.redirect_url) {
                    $('#longLink').text(response.info.redirect_url.length>40 ? response.info.redirect_url.substring(0, 40)+'...' : response.info.redirect_url);
                }
            }
        } else {
            helpers.tools.copyToClipboard(shortUrl);
        }

        helpers.tools.hideBadgeLoading();

        chrome.action.setBadgeText({
            text: '',
        });

        chrome.action.setTitle({title: 'Short Link:\n'+shortUrl+'\n\n'+longLink+'\n\n'});

        var linkHistory=await helpers.storage.getValue('linkHistory');
        if (!linkHistory) {
            linkHistory=[];
        }

        linkHistory.unshift({
            shortUrl: shortUrl,
            longUrl: longLink,
            date: new Date(),
        });

        linkHistory=linkHistory.slice(0, 10);

        await helpers.storage.setValue('linkHistory', linkHistory);

        return {shortUrl: shortUrl, longUrl: longLink};
    };

    var handleError=async function (error) {
        if (typeof jQuery!='undefined') {
            helpers.tools.hideLoading();
            // $('#shortenedLink').val('Failed to shorten');
            $('#defaultShortenerFailed').hide();
            let playSound=await helpers.storage.getValue('notificationSound');
            if (playSound) {
                $('#errorAudio')[0].play();
            }

            if (error&&error.message) {
                $.growl({
                    title: '',
                    message: error.message,
                    style: 'error',
                });
            }
        }

        helpers.tools.hideBadgeLoading();

        if (error&&error.message.includes('API key')) {
            setTimeout(function () {
                chrome.tabs.create({
                    url: 'https://goo.by/user/login',
                });
            }, 2000);
        }
    };


    return {
        getShortLink: getShortLink,
    };
})();
