function copyLink() {
    var shortUrl=$('#shortenedLink').val();
    helpers.tools.copyToClipboard(shortUrl);

    $.growl({
        title: '',
        message: helpers.tools.localizeString(null, 'linkHasBeenCopied'),
        style: 'success',
    });
}

async function hideShowLink() {
    var gooapiKey=await helpers.storage.getValue('goobyapi');

    $('#my-account, #sign-up, #sign-up-spacer').hide();
    if (gooapiKey) {
        $('#my-account').show();
    } else {
        $('#sign-up, #sign-up-spacer').show();
    }
}



async function renderLinkHistory() {
    $('#link-history-container').toggleClass('hidden');
    var includeHttps=await helpers.storage.getValue('includeHttps');
    var linkHistory=await helpers.storage.getValue('linkHistory');
    $('#link-history-list').html('');
    for (var i=0; i<linkHistory.length; i++) {
        var shortUrl=linkHistory[i].shortUrl;
        if (!includeHttps) {
            shortUrl=linkHistory[i].shortUrl.replace(/(^\w+:|^)\/\//, '');
        }

        $('#link-history-list').append(`<a href="#" data-short-url="${shortUrl}" class="list-group-item list-group-item-action flex-column align-items-start mb-2 link-history-copy">
			<div class="d-flex w-100 justify-content-between">
				<h5 class="mb-1">${shortUrl}</h5>
			</div>
			<div class="mb-1 text-truncate text-small">${linkHistory[i].longUrl}</div>
			<small class="text-muted">${linkHistory[i].date ? moment(linkHistory[i].date).fromNow() : '--'}</small>
		</a>`);
    }
}


$(document).on('click', '#copy-button', function () {
    copyLink();
});

$(document).on('click', '#qr-button', function (e) {
    e.preventDefault();
    $('.qr-image').toggleClass('hidden');

    if ($('#url-title').val()) {
        $('#url-title-wapper').addClass('hidden');
    }

    if ($('#url-description').val()) {
        $('#url-description-wapper').addClass('hidden');
    }

    $('#link-history-container').addClass('hidden');
});

$(document).on('click', '#details-button', function (e) {
    e.preventDefault();
    if ($('#url-title').val()) {
        $('#url-title-wapper').toggleClass('hidden');
    }

    if ($('#url-description').val()) {
        $('#url-description-wapper').toggleClass('hidden');
    }

    $('.qr-image').addClass('hidden');
    $('#link-history-container').addClass('hidden');
});

$(document).on('click', '#link-history', function () {
    if ($('#url-title').val()) {
        $('#url-title-wapper').addClass('hidden');
    }

    if ($('#url-description').val()) {
        $('#url-description-wapper').addClass('hidden');
    }

    $('.qr-image').addClass('hidden');

    renderLinkHistory();
});

$(document).on('click', '#shortenedLink', function () {
    $('#shortenedLink').select();
});

$(document).on('change keyup paste', '#shortenedLink', function () {
    if ($(this).val().length>0) {
        $('#clear-button').show();
    } else {
        $('#clear-button').hide();
    }

});
$(document).on('click', '.link-history-copy', function (e) {
    e.preventDefault();
    helpers.tools.copyToClipboard($(this).data('shortUrl'));

    $.growl({
        title: '',
        message: helpers.tools.localizeString(null, 'linkHasBeenCopied'),
        style: 'success',
    });
});

$(document).on('click', '#clear-button', function () {
    $('#shortenedLink').val('');
    $('#copy-button').hide();
    $('#clear-button').hide();
    $('#link-info').hide();
    $('#short-button').show();
});
$(document).on('click', '#short-button', function () {
    let longLink=$('#shortenedLink').val();
    helpers.tools.showLoading();
    setTimeout(function () {
        helpers.short.getShortLink(longLink);
    }, 1000);


});

chrome.tabs.query(
    {
        active: true, // Select active tabs
        lastFocusedWindow: true, // In the current window
    },
    async function (tabs) {
        if (tabs.length>0) {
            tab=tabs[0];
        } else {
            return;
        }
        helpers.tools.localizeHtmlPage(document);
        var currentUrlSettings = await helpers.storage.getValue('ShortCurrentUrl');

        if (currentUrlSettings!=1) {
            helpers.tools.hideLoading();
        }

        hideShowLink();

        $('#copy-button').hide();
        $('#link-info').hide();


        if (currentUrlSettings==1||currentUrlSettings==2) {

            if (tab.url.startsWith('https://')) {
                $('#shortenedLink').val(tab.url);
            }

        }

        if (currentUrlSettings==1){
            setTimeout(function () {
                helpers.short.getShortLink(tab.url);
            }, 1000);
        }



    }
);
