let init = async function () {
	helpers.tools.localizeHtmlPage(document);

	var settingsSaved = function () {
		Swal.fire({
			type: 'success',
			title: 'Settings Saved',
			showConfirmButton: false,
			timer: 1500,
		});
	};

	// $('#goo-key').val(await helpers.storage.getValue('goobyapi'));
	//
	//
	// $('#goo-key').blur(async function () {
	// 	await helpers.storage.setValue('goobyapi', $('#goo-key').val());
	// });



	$('#notification-sound').prop('checked', await helpers.storage.getValue('notificationSound'));
	$('#current-url').val( await helpers.storage.getValue('ShortCurrentUrl')?? 1).change();
	$('#current-domain').val( await helpers.storage.getValue('ShortCurrentDomain')?? 'https://goo.by').change();
	$('#copy-to-clipboard').prop('checked', (await helpers.storage.getValue('copyToClipboard')) ?? true);
	$('#right-click').prop('checked', (await helpers.storage.getValue('rightClick')) ?? false);

	$('#settings-form').submit(async function (e) {
		e.preventDefault();

		// await helpers.storage.setValue('gooapi', $('#goo-key').val());
		await helpers.storage.setValue('notificationSound', $('#notification-sound')[0].checked);
		await helpers.storage.setValue('ShortCurrentUrl', $('#current-url').val());
		await helpers.storage.setValue('copyToClipboard', $('#copy-to-clipboard')[0].checked);
		await helpers.storage.setValue('rightClick', $('#right-click')[0].checked);
		await helpers.storage.setValue('ShortCurrentDomain', $('#current-domain').val());

		settingsSaved();

		chrome.permissions.request(
			{
				permissions: ['scripting'],
			},
			(granted) => {}
		);

		chrome.runtime.sendMessage(
			{
				message: 'update_context_menu',
			},
			(response) => {}
		);
	});
};

init();
