self.helpers.storage = (function () {
	var buildKey = function (key) {
		if (key.startsWith('ls-')) {
			return key;
		}

		return 'ls-' + key;
	};
	async function getValue(key) {
		return await new Promise(function (resolve, reject) {
			if (!chrome || !chrome.storage || !chrome.storage.local) {
				return reject(new Error('Storage required'));
			}

			var newKey = buildKey(key);
			console.log('Getting: ' + newKey);
			chrome.storage.local.get(newKey, function (val) {
				if (val) {
					return resolve(val[Object.keys(val)[0]]);
				}

				resolve();
			});
		});
	}

	async function setValue(key, dataValue) {
		return await new Promise(function (resolve, reject) {
			if (typeof chrome !== 'undefined' && chrome.storage && chrome.storage.local) {
				var newKey = buildKey(key);
				console.log('Saving: ' + newKey);
				chrome.storage.local.set(
					{
						[newKey]: dataValue,
					},
					function () {
						resolve(newKey);
					}
				);
			}
		});
	}

	return {
		getValue: getValue,
		setValue: setValue,
	};
})();
