importScripts('helpers.js', 'storage.js');

//Set browser for Firefox extensions to be chrome
if (typeof browser !== 'undefined') {
	self.chrome = browser;
}

if (typeof chrome !== 'undefined' && chrome.runtime && chrome.runtime.onInstalled) {
	chrome.runtime.onInstalled.addListener(function (details) {
		if (details.reason == 'install') {

			chrome.tabs.create({
				url: 'https://goo.by/user/login',
			});
		} else if (details.reason == 'update') {
		}
	});
}

if (typeof chrome !== 'undefined' && chrome.runtime && chrome.runtime.setUninstallURL) {
	chrome.runtime.setUninstallURL('https://goo.by');
}

let updateContextMenu = async function () {
	if (chrome && chrome.contextMenus) {
		await chrome.contextMenus.removeAll( function () {
			let rightClickId = 'shorten-link-copy';
			let rightClickEnabled = ( helpers.storage.getValue('rightClick')) ?? true;

			if (rightClickEnabled) {
				 chrome.contextMenus.create({
					id: rightClickId,
					title: 'Shorten Link and Copy',
					type: 'normal',
					contexts: ['link', 'page', 'image'],
				});
			}
		});
	}
};

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
	if (request.message === 'update_context_menu') {
		updateContextMenu();
		return true;
	}

	if (request.message === 'set-token') {
		saveSettings(request.token);
		return true;
	}
});

let saveSettings= async function (token) {
	await helpers.storage.setValue('goobyapi', token);
	await helpers.storage.setValue('notificationSound',0);
	await helpers.storage.setValue('copyToClipboard', 1);
	await helpers.storage.setValue('ShortCurrentUrl', 1);
	await helpers.storage.setValue('rightClick', 1);
}

let onClickedListener =  function (data, tab) {

	var longUrl = data.pageUrl;
	if (data && data.mediaType === 'image' && data.srcUrl) {
		longUrl = data.srcUrl;
	} else if (data && data.linkUrl) {
		longUrl = data.linkUrl;
	} else if (data && data.pageUrl) {
		longUrl = data.pageUrl;
	}

	 helpers.short.getShortLink(longUrl);
};

// chrome.contextMenus.onClicked.removeListener(onClickedListener);
chrome.contextMenus.onClicked.addListener(onClickedListener);

//Init to enable
updateContextMenu();
